#include "probes.h"

int initProbesSys()
{
	FILE *config = NULL;
	int size;
	char buf[MAX_BUF];
	
	config = fopen(CONFIGFILE, "r");
	if (config == NULL)
	{
		LOGI("Error: Can't open [%s]", CONFIGFILE);
		//printf("Error: Can't open [%s]\n", CONFIGFILE);
		return -1;
	}
	
	if (fgets(buf, MAX_BUF, config) == NULL)
	{
		LOGI("Error: Can't read number of items");
		//printf("Error: Can't read number of items\n");
		return -1;
	}
	
	size = atoi(buf);
	if (size < 0)
	{
		LOGI("Error: Get error value in size of config (%d)", size);
		//printf("Error: Get error value in size of config (%d)\n", size);
		return -1;
	}

	if(loadActiveProbe() == -1 || initLogSpace(size) == -1 || loadCaller() == -1)
		return -1;
		
	if (config != NULL) fclose(config);

	return 0;
}

void closeProbeSys()
{
	unloadActiveProbe();
	desLogSpace();
	unloadCaller();
}
